<?php
/*
Plugin Name: myJavascript
Plugin URI: https://www.marcocekada.com/blog//search.php?stype=full&q=plugin+myjavascript
Description: Adds your custom javascript to FlatPress
Author: Marco Cekada
Version: 1.0
Author URI: https://www.marcocekada.com/blog
*/ 
 
function plugin_myjavascript_footer() {
    $qscfg = plugin_getoptions('myjavascript');
    if (isset($qscfg['mycode'])) {
		$script= $qscfg['mycode'];
        echo $script;
	}
}
 
add_action('wp_footer', 'plugin_myjavascript_footer');

if (class_exists('AdminPanelAction')){
	/**
	 * Provides an admin panel entry for myJavascript setup.
	 */
	class admin_plugin_myjavascript extends AdminPanelAction {
		var $langres = 'plugin:myjavascript';
		
		/**
		 * Initializes this panel.
		 */
		function setup() {
			$this->smarty->assign('admin_resource', "plugin:myjavascript/admin.plugin.myjavascript");
		}
		
		/**
		 * Setups the default panel.
		 */
		function main() {
			$qscfg = plugin_getoptions('myjavascript');
			$qscfg['mycode'] = isset($qscfg['mycode'])
				? $qscfg['mycode']
				: 1;
			$this->smarty->assign('qscfg', $qscfg);
		}
		
		/**
		 * Will be executed when the QSF configuration is send.
		 *
		 * @return int
		 */
		function onsubmit($data = null) {
			if ($_POST['qs-mycode']){
				$mycode = isset($_POST['qs-mycode'])
					? stripslashes($_POST['qs-mycode'])
					: '';
				//$mycode = str_replace("\r", "\n", $mycode);
				
				
				plugin_addoption('myjavascript', 'mycode', $mycode);
				plugin_saveoptions('myjavascript');
				$this->smarty->assign('success', 1);
			} else {
			 	$this->smarty->assign('success', -1);
			}
			return 2;
		}
	}
	admin_addpanelaction('plugin', 'myjavascript', true);
}

?>